/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.ui.bonsai.earth.util;

import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.ui.bonsai.config.AbstractNodeConfigBean;
import com.ibm.hwmca.ui.bonsai.config.BonsaiConfigException;
import com.ibm.hwmca.ui.bonsai.earth.BonsaiTreeNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class BonsaiRegurgitater {
    private static final String TRACEMASK_T = "XBUIREGT";
    private static final String TRACEMASK_F = "XBUIREGF";
    private static final String TRACEMASK_D = "XBUIREGD";

    private BonsaiRegurgitater() {
    }

    public static List getTrees(List rootNodeIds, Map configBeans, BonsaiTreeNode parent) throws BonsaiConfigException {
        Trace.trace(TRACEMASK_T, "--> BonsaiRegurgitater.getTrees(rootNodesIds, configBeans, parent)");
        TreeRegurgitater regurgitater = new TreeRegurgitater(configBeans);
        ArrayList<BonsaiTreeNode> rootNodes = new ArrayList<BonsaiTreeNode>();
        BonsaiTreeNode[] nodes = null;
        Iterator iterator = rootNodeIds.iterator();
        while (iterator.hasNext()) {
            nodes = regurgitater.getTreeNodes((String)iterator.next(), parent);
            for (int i = 0; i < nodes.length; ++i) {
                rootNodes.add(nodes[i]);
            }
        }
        Trace.trace(TRACEMASK_D, rootNodes.size() + " root nodes created and returned");
        Trace.trace(TRACEMASK_T, "<-- BonsaiRegurgitater.getTrees()");
        return rootNodes;
    }

    private static class TreeRegurgitater {
        private Map nodeMap;

        TreeRegurgitater(Map nodeMap) {
            Trace.trace(BonsaiRegurgitater.TRACEMASK_D, "<> BonsaiRegurgitater.TreeRegurgitater(" + nodeMap + ")");
            this.nodeMap = nodeMap;
        }

        BonsaiTreeNode[] getTreeNodes(String nodeKey, BonsaiTreeNode parent) throws BonsaiConfigException {
            Trace.trace(BonsaiRegurgitater.TRACEMASK_D, "<> BonsaiRegurgitater.TreeRegurgitater.getTreeNodes(" + nodeKey + ", " + parent + ")");
            AbstractNodeConfigBean bean = (AbstractNodeConfigBean)this.nodeMap.get(nodeKey);
            if (bean == null) {
                throw new BonsaiConfigException("The node " + nodeKey + " is not defined in the XML!");
            }
            BonsaiTreeNode[] nodes = bean.getTreeNodes(parent);
            for (int i = 0; i < nodes.length; ++i) {
                Iterator childKeys = bean.getChildren().iterator();
                while (childKeys.hasNext()) {
                    nodes[i].addChildren(this.getTreeNodes((String)childKeys.next(), nodes[i]));
                }
            }
            return nodes;
        }
    }
}

